@extends('layouts.adminDashboard',['title'=> "Dashboard"])
@section('statusmenue')
<div class="lg:flex lg:flex-row px-4 mt-4 w-full">


    <div class="w-full lg:w-1/4 md:w-full mx-2 p-6 bg-white border border-gray-200 rounded-lg shadow-sm dark:bg-gray-800 dark:border-gray-700">

        <img class="w-14 h-14 text-gray-500 dark:text-gray-400 mb-3 border-2 border-solid rounded-xl border-gray-300" src="/icons/breafecase.png" />
        <p class="mb-3 font-normal text-gray-500 dark:text-gray-400">Total Users</p>

        <h5 class=" mt-6 text-2xl font-semibold tracking-tight text-gray-900 dark:text-white">{{$totalUser}}</h5>

    </div>



    <div class="w-full lg:w-1/4 mx-2 p-6 bg-white border border-gray-200 rounded-lg shadow-sm dark:bg-gray-800 dark:border-gray-700">

        <img class="w-14 h-14 text-gray-500 dark:text-gray-400 mb-3 border-2 border-solid rounded-xl border-gray-300" src="/icons/chear.png" />
        <p class="mb-3 font-normal text-gray-500 dark:text-gray-400">Total client</p>

        <h5 class=" mt-6 text-2xl font-semibold tracking-tight text-gray-900 dark:text-white">{{$totalClient}}</h5>

    </div>




    <div class="w-full lg:w-1/4 mx-2 p-6 bg-white border border-gray-200 rounded-lg shadow-sm dark:bg-gray-800 dark:border-gray-700">
        <img class="w-14 h-14 text-gray-500 dark:text-gray-400 mb-3 border-2 border-solid rounded-xl border-gray-300" src="/icons/alert.png" />

        <p class="mb-3 font-normal text-gray-500 dark:text-gray-400">Support Tickets</p>

        <h5 class=" mt-6 text-2xl font-semibold tracking-tight text-gray-900 dark:text-white">0</h5>

    </div>




    <div class="w-full lg:w-1/4 mx-2 p-6 bg-white border border-gray-200 rounded-lg shadow-sm dark:bg-gray-800 dark:border-gray-700">
        <img class="w-14 h-14 text-gray-500 dark:text-gray-400 mb-3 border-2 border-solid rounded-xl border-gray-300" src="/icons/clock2.png" />

        <p class="mb-3 font-normal text-gray-500 dark:text-gray-400">Imprest</p>


        <h5 class=" mt-6 text-2xl font-semibold tracking-tight text-gray-900 dark:text-white">{{$totalImprest}}</h5>


    </div>

</div>
@stop
@section('content')

<div class="w-full lg:flex lg:justify-between">

    <div class="lg:w-1/2 w-full mx-2 mt-4 relative  shadow-md sm:rounded-lg overflow-auto">
        <div class="mx-4 flex flex-row justify-between content-between">
            <div class="mt-2">
                <div class="Imprest">
                    Imprest
                </div>
                <div class="pettyCash">
                    Petty cash expenses
                </div>
            </div>
            <div class="mt-2">
                <label for="table-search" class="sr-only">Search</label>
                <div class="relative">
                    <div class="absolute inset-y-0 rtl:inset-r-0 start-0 flex items-center ps-3 pointer-events-none">
                        <svg class="w-4 h-4 text-gray-500 dark:text-gray-400" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 20 20">
                            <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m19 19-4-4m0-7A7 7 0 1 1 1 8a7 7 0 0 1 14 0Z" />
                        </svg>
                    </div>
                    <input type="text" id="table-search-users" class="block p-2 ps-10 text-sm text-gray-900 border border-gray-300 rounded-lg bg-gray-50 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" placeholder="Search for users">
                </div>
            </div>
        </div>
        <table class="w-full text-sm text-left rtl:text-right text-gray-500 dark:text-gray-400">
            <thead class="text-xs text-gray-700 uppercase bg-gray-50 dark:bg-gray-700 dark:text-gray-400">
                <tr>

                    <th scope="col" class="px-6 py-3">
                        Account Details
                    </th>
                    <th scope="col" class="px-6 py-3">
                        Bank Details
                    </th>
                    <th scope="col" class="px-6 py-3">
                        Amount ₦/ Status
                    </th>
                    <th scope="col" class="px-6 py-3">
                        Action
                    </th>

                </tr>
            </thead>
            <tbody>
                @if(count($imprests)>0)
                @foreach($imprests->all() as $imprest)
                <tr class="bg-white border-b dark:bg-gray-800 dark:border-gray-700 border-gray-200 hover:bg-gray-50 dark:hover:bg-gray-600">

                    <th scope="row" class=" px-6 py-4 text-gray-900 whitespace-nowrap dark:text-white">

                        <a href="/invoice?id={{$imprest->id}}">
                            <div class="ps-3">
                                <div class="text-base font-semibold">{{$imprest->accountName}}</div>
                                <div class="font-normal text-gray-500">{{$imprest->accountNumber}}</div>
                            </div>
                        </a>
                    </th>
                    <td class="px-6 py-4">
                        <div class="flex items-center">
                            {{$imprest->bank}}
                        </div>
                        <div class="flex items-center">
                            {{$imprest->bankCode}}
                        </div>

                    </td>
                    <td class="px-6 py-4">
                        <div class="flex items-center">
                            {{number_format($imprest->amount/100)}}
                        </div>
                        @if($imprest->status=="pending")
                        <div class="flex items-center text-yellow-500">
                            @elseif($imprest->status=="approved" || $imprest->status=="paid")
                            <div class="flex items-center text-green-500">
                                @elseif($imprest->status=="canceled")
                                <div class="flex items-center text-red-500">
                                    @else
                                    <div class="flex items-center">
                                        @endif
                                        {{$imprest->status}}
                                    </div>
                    </td>

                    <td class="flex px-6 py-4">
                        @if($imprest->status=="pending")
                        <form action="/admin/imprest" method="post">
                            @csrf
                            <input type="hidden" name="invoiceId" value="{{$imprest->id}}">
                            <button type="submit" title="Approve request" class="mx-1 h-10 w-10 bg-gray-100 rounded-lg hover:bg-green-200">
                                <img class="h-10 w-10 rounded-lg" src="/icons/check-green.png" alt="" srcset="">
                            </button>
                        </form>
                        <a href="/invoice?id={{$imprest->id}}" title="View / Edit request" class="mx-1 h-10 w-10 bg-gray-100 rounded-lg hover:bg-yellow-200">
                            <img class="h-10 w-10 rounded-lg" src="/icons/ButtonEdit.png" alt="" srcset="">
                        </a>
                        @endif
                        @if($imprest->status=="approved")
                        <button type="button" onclick='showPayModal("{{$imprest->id}}|{{$imprest->accountNumber}}|{{$imprest->bankCode}}")' title="Pay to bank" class="mx-1 h-10 w-10 bg-gray-100 rounded-lg hover:bg-green-200 flex justify-center items-center">
                            <img class="h-5 w-5 rounded-lg" src="/icons/payment-method.png" alt="" srcset="">
                        </button>
                        <div id="modal{{$imprest->id}}" tabindex="-1" class="hidden bg-gray-800 bg-opacity-70 flex overflow-y-auto overflow-x-hidden fixed top-0  z-50 justify-center  w-full md:inset-0 h-[calc(100%-1rem)] max-h-full">
                            <div class="relative p-4 w-full max-w-md max-h-full">
                                <!-- Modal content -->
                                <div class="relative bg-white rounded-lg shadow-sm dark:bg-gray-700">
                                    <!-- Modal header -->
                                    <div class="flex items-center justify-between p-4 md:p-5 border-b rounded-t dark:border-gray-600 border-gray-200">
                                        <h3 class="text-xl font-semibold text-gray-900 dark:text-white">
                                            Confirm payment details
                                        </h3>
                                        <button type="button" class="end-2.5 text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm w-8 h-8 ms-auto inline-flex justify-center items-center dark:hover:bg-gray-600 dark:hover:text-white" data-modal-hide="authentication-modal">
                                            <svg class="w-3 h-3" onclick='showPayModal("{{$imprest->id}}|{{$imprest->accountNumber}}|{{$imprest->bankCode}}")' xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
                                                <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6" />
                                            </svg>
                                            <span class="sr-only">Close modal</span>
                                        </button>
                                    </div>
                                    <!-- Modal body -->
                                    <div class="p-4 md:p-5">
                                        <form class="space-y-4" action="/admin/imprest-payout" method="post">
                                            @csrf

                                            <input type="hidden" name="invoiceId" value="{{$imprest->id}}">
                                            <div>
                                                <label class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Account number</label>
                                                <label class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">{{$imprest->accountNumber}}</label>
                                            </div>
                                            <div>
                                                <label class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Account name</label>
                                                <label id="accountName{{$imprest->id}}" class="flex items-center block mb-2 text-sm font-medium text-gray-900 dark:text-white">{{$imprest->accountName}}</label>
                                            </div>
                                            <div>
                                                <label class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Bank</label>
                                                <label class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">{{$imprest->bank}}</label>
                                            </div>
                                            <div>
                                                <label class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Total Amount</label>
                                                <label class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">{{number_format($imprest->amount/100)}}</label>
                                            </div>
                                            <div class="text-sm font-medium text-yellow-500 dark:text-yellow-300">
                                                Please Note! Once Pay Now is clicked the above amount will be transfered to the account details.
                                            </div>
                                            <button type="submit" class="w-full text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">Pay now</button>

                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>

                        @endif
                        @if($imprest->status!="canceled"&& $imprest->status!="paid")
                        <form action="/admin/imprest-cancel" method="post">
                            @csrf
                            <input type="hidden" name="invoiceId" value="{{$imprest->id}}">
                            <button type="submit" title="Cancele request" class="mx-1 h-10 w-10 bg-red-100 rounded-lg hover:bg-red-200 flex justify-center items-center">
                                <img class="h-5 w-5 rounded-lg" src="/icons/cancelled.png" alt="" srcset="">
                            </button>
                        </form>
                        @endif
                    </td>

                </tr>
                @endforeach
                @endif

            </tbody>
        </table>
        <nav class="flex flex-col md:flex-row justify-between items-start md:items-center space-y-3 md:space-y-0 p-4" aria-label="Table navigation">
            <span class="text-sm font-normal text-gray-500 dark:text-gray-400">
                Showing
                <span class="font-semibold text-gray-900 dark:text-white">1-10</span>
                of
                <span class="font-semibold text-gray-900 dark:text-white">1000</span>
            </span>
            <ul class="inline-flex items-stretch -space-x-px">
                <li>
                    <a href="#" class="flex items-center justify-center h-full py-1.5 px-3 ml-0 text-gray-500 bg-white rounded-l-lg border border-gray-300 hover:bg-gray-100 hover:text-gray-700 dark:bg-gray-800 dark:border-gray-700 dark:text-gray-400 dark:hover:bg-gray-700 dark:hover:text-white">
                        <span class="sr-only">Previous</span>
                        <svg class="w-5 h-5" aria-hidden="true" fill="currentColor" viewbox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd" d="M12.707 5.293a1 1 0 010 1.414L9.414 10l3.293 3.293a1 1 0 01-1.414 1.414l-4-4a1 1 0 010-1.414l4-4a1 1 0 011.414 0z" clip-rule="evenodd" />
                        </svg>
                    </a>
                </li>
                <li>
                    <a href="#" class="flex items-center justify-center text-sm py-2 px-3 leading-tight text-gray-500 bg-white border border-gray-300 hover:bg-gray-100 hover:text-gray-700 dark:bg-gray-800 dark:border-gray-700 dark:text-gray-400 dark:hover:bg-gray-700 dark:hover:text-white">1</a>
                </li>
                <li>
                    <a href="#" class="flex items-center justify-center text-sm py-2 px-3 leading-tight text-gray-500 bg-white border border-gray-300 hover:bg-gray-100 hover:text-gray-700 dark:bg-gray-800 dark:border-gray-700 dark:text-gray-400 dark:hover:bg-gray-700 dark:hover:text-white">2</a>
                </li>
                <li>
                    <a href="#" aria-current="page" class="flex items-center justify-center text-sm z-10 py-2 px-3 leading-tight text-primary-600 bg-primary-50 border border-primary-300 hover:bg-primary-100 hover:text-primary-700 dark:border-gray-700 dark:bg-gray-700 dark:text-white">3</a>
                </li>
                <li>
                    <a href="#" class="flex items-center justify-center text-sm py-2 px-3 leading-tight text-gray-500 bg-white border border-gray-300 hover:bg-gray-100 hover:text-gray-700 dark:bg-gray-800 dark:border-gray-700 dark:text-gray-400 dark:hover:bg-gray-700 dark:hover:text-white">...</a>
                </li>
                <li>
                    <a href="#" class="flex items-center justify-center text-sm py-2 px-3 leading-tight text-gray-500 bg-white border border-gray-300 hover:bg-gray-100 hover:text-gray-700 dark:bg-gray-800 dark:border-gray-700 dark:text-gray-400 dark:hover:bg-gray-700 dark:hover:text-white">100</a>
                </li>
                <li>
                    <a href="#" class="flex items-center justify-center h-full py-1.5 px-3 leading-tight text-gray-500 bg-white rounded-r-lg border border-gray-300 hover:bg-gray-100 hover:text-gray-700 dark:bg-gray-800 dark:border-gray-700 dark:text-gray-400 dark:hover:bg-gray-700 dark:hover:text-white">
                        <span class="sr-only">Next</span>
                        <svg class="w-5 h-5" aria-hidden="true" fill="currentColor" viewbox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd" />
                        </svg>
                    </a>
                </li>
            </ul>
        </nav>
    </div>

    <div class="lg:w-1/2 w-full mx-2 mt-4 relative  shadow-md sm:rounded-lg overflow-auto">
        <div class="flex items-center justify-between flex-column flex-wrap md:flex-row space-y-4 md:space-y-0 pb-4 bg-white dark:bg-gray-900">

            <div class="mt-2 mx-4">
                <div class="Imprest">
                    All tickets
                </div>
                <div class="pettyCash">
                    Petty cash expenses
                </div>
            </div>
            <div class="mt-2 mx-4">
                <label for="table-search" class="sr-only">Search</label>
                <div class="relative">
                    <div class="absolute inset-y-0 rtl:inset-r-0 start-0 flex items-center ps-3 pointer-events-none">
                        <svg class="w-4 h-4 text-gray-500 dark:text-gray-400" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 20 20">
                            <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m19 19-4-4m0-7A7 7 0 1 1 1 8a7 7 0 0 1 14 0Z" />
                        </svg>
                    </div>
                    <input type="text" id="table-search-users" class="block p-2 ps-10 text-sm text-gray-900 border border-gray-300 rounded-lg bg-gray-50 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" placeholder="Search for users">
                </div>
            </div>
        </div>
        <table class="w-full text-sm text-left rtl:text-right text-gray-500 dark:text-gray-400">
            <thead class="text-xs text-gray-700 uppercase bg-gray-50 dark:bg-gray-700 dark:text-gray-400">
                <tr>

                    <th scope="col" class="px-6 py-3">
                        Name
                    </th>
                    <th scope="col" class="px-6 py-3">
                        Position
                    </th>
                    <th scope="col" class="px-6 py-3">
                        Status
                    </th>
                    <th scope="col" class="px-6 py-3">
                        Action
                    </th>
                </tr>
            </thead>
            <tbody>
                <tr class="bg-white border-b dark:bg-gray-800 dark:border-gray-700 border-gray-200 hover:bg-gray-50 dark:hover:bg-gray-600">

                    <th scope="row" class="flex items-center px-6 py-4 text-gray-900 whitespace-nowrap dark:text-white">
                        <a href="#" class="">
                            <img class="w-10 h-10 rounded-full" src="/images/profilepictur.png" alt="Jese image">
                        </a>
                        <div class="ps-3">
                            <a href="#" class="">
                                <div class="text-base font-semibold">Neil Sims</div>
                            </a>
                            <a href="#" class="">
                                <div class="font-normal text-gray-500">neil.sims@flowbite.com</div>
                            </a>
                        </div>
                    </th>
                    <td class="px-6 py-4">
                        React Developer
                    </td>
                    <td class="px-6 py-4">
                        <div class="flex items-center">
                            <div class="h-2.5 w-2.5 rounded-full bg-green-500 me-2"></div> Online
                        </div>
                    </td>
                    <td class="px-6 py-4">
                        <a href="#" class="font-medium text-blue-600 dark:text-blue-500 hover:underline">Edit user</a>
                    </td>
                </tr>
                <tr class="bg-white border-b dark:bg-gray-800 dark:border-gray-700 border-gray-200 hover:bg-gray-50 dark:hover:bg-gray-600">

                    <th scope="row" class="flex items-center px-6 py-4 font-medium text-gray-900 whitespace-nowrap dark:text-white">
                        <img class="w-10 h-10 rounded-full" src="/images/profilepictur.png" alt="Jese image">
                        <div class="ps-3">
                            <div class="text-base font-semibold">Bonnie Green</div>
                            <div class="font-normal text-gray-500">bonnie@flowbite.com</div>
                        </div>
                    </th>
                    <td class="px-6 py-4">
                        Designer
                    </td>
                    <td class="px-6 py-4">
                        <div class="flex items-center">
                            <div class="h-2.5 w-2.5 rounded-full bg-green-500 me-2"></div> Online
                        </div>
                    </td>
                    <td class="px-6 py-4">
                        <a href="#" class="font-medium text-blue-600 dark:text-blue-500 hover:underline">Edit user</a>
                    </td>
                </tr>
                <tr class="bg-white border-b dark:bg-gray-800 dark:border-gray-700 border-gray-200 hover:bg-gray-50 dark:hover:bg-gray-600">

                    <th scope="row" class="flex items-center px-6 py-4 font-medium text-gray-900 whitespace-nowrap dark:text-white">
                        <img class="w-10 h-10 rounded-full" src="/images/profilepictur.png" alt="Jese image">
                        <div class="ps-3">
                            <div class="text-base font-semibold">Jese Leos</div>
                            <div class="font-normal text-gray-500">jese@flowbite.com</div>
                        </div>
                    </th>
                    <td class="px-6 py-4">
                        Vue JS Developer
                    </td>
                    <td class="px-6 py-4">
                        <div class="flex items-center">
                            <div class="h-2.5 w-2.5 rounded-full bg-green-500 me-2"></div> Online
                        </div>
                    </td>
                    <td class="px-6 py-4">
                        <a href="#" class="font-medium text-blue-600 dark:text-blue-500 hover:underline">Edit user</a>
                    </td>
                </tr>
                <tr class="bg-white border-b dark:bg-gray-800 dark:border-gray-700 border-gray-200 hover:bg-gray-50 dark:hover:bg-gray-600">

                    <th scope="row" class="flex items-center px-6 py-4 font-medium text-gray-900 whitespace-nowrap dark:text-white">
                        <img class="w-10 h-10 rounded-full" src="/images/profilepictur.png" alt="Jese image">
                        <div class="ps-3">
                            <div class="text-base font-semibold">Thomas Lean</div>
                            <div class="font-normal text-gray-500">thomes@flowbite.com</div>
                        </div>
                    </th>
                    <td class="px-6 py-4">
                        UI/UX Engineer
                    </td>
                    <td class="px-6 py-4">
                        <div class="flex items-center">
                            <div class="h-2.5 w-2.5 rounded-full bg-green-500 me-2"></div> Online
                        </div>
                    </td>
                    <td class="px-6 py-4">
                        <a href="#" class="font-medium text-blue-600 dark:text-blue-500 hover:underline">Edit user</a>
                    </td>
                </tr>

            </tbody>
        </table>
        <nav class="flex flex-col md:flex-row justify-between items-start md:items-center space-y-3 md:space-y-0 p-4" aria-label="Table navigation">
            <span class="text-sm font-normal text-gray-500 dark:text-gray-400">
                Showing
                <span class="font-semibold text-gray-900 dark:text-white">1-10</span>
                of
                <span class="font-semibold text-gray-900 dark:text-white">1000</span>
            </span>
            <ul class="inline-flex items-stretch -space-x-px">
                <li>
                    <a href="#" class="flex items-center justify-center h-full py-1.5 px-3 ml-0 text-gray-500 bg-white rounded-l-lg border border-gray-300 hover:bg-gray-100 hover:text-gray-700 dark:bg-gray-800 dark:border-gray-700 dark:text-gray-400 dark:hover:bg-gray-700 dark:hover:text-white">
                        <span class="sr-only">Previous</span>
                        <svg class="w-5 h-5" aria-hidden="true" fill="currentColor" viewbox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd" d="M12.707 5.293a1 1 0 010 1.414L9.414 10l3.293 3.293a1 1 0 01-1.414 1.414l-4-4a1 1 0 010-1.414l4-4a1 1 0 011.414 0z" clip-rule="evenodd" />
                        </svg>
                    </a>
                </li>
                <li>
                    <a href="#" class="flex items-center justify-center text-sm py-2 px-3 leading-tight text-gray-500 bg-white border border-gray-300 hover:bg-gray-100 hover:text-gray-700 dark:bg-gray-800 dark:border-gray-700 dark:text-gray-400 dark:hover:bg-gray-700 dark:hover:text-white">1</a>
                </li>
                <li>
                    <a href="#" class="flex items-center justify-center text-sm py-2 px-3 leading-tight text-gray-500 bg-white border border-gray-300 hover:bg-gray-100 hover:text-gray-700 dark:bg-gray-800 dark:border-gray-700 dark:text-gray-400 dark:hover:bg-gray-700 dark:hover:text-white">2</a>
                </li>
                <li>
                    <a href="#" aria-current="page" class="flex items-center justify-center text-sm z-10 py-2 px-3 leading-tight text-primary-600 bg-primary-50 border border-primary-300 hover:bg-primary-100 hover:text-primary-700 dark:border-gray-700 dark:bg-gray-700 dark:text-white">3</a>
                </li>
                <li>
                    <a href="#" class="flex items-center justify-center text-sm py-2 px-3 leading-tight text-gray-500 bg-white border border-gray-300 hover:bg-gray-100 hover:text-gray-700 dark:bg-gray-800 dark:border-gray-700 dark:text-gray-400 dark:hover:bg-gray-700 dark:hover:text-white">...</a>
                </li>
                <li>
                    <a href="#" class="flex items-center justify-center text-sm py-2 px-3 leading-tight text-gray-500 bg-white border border-gray-300 hover:bg-gray-100 hover:text-gray-700 dark:bg-gray-800 dark:border-gray-700 dark:text-gray-400 dark:hover:bg-gray-700 dark:hover:text-white">100</a>
                </li>
                <li>
                    <a href="#" class="flex items-center justify-center h-full py-1.5 px-3 leading-tight text-gray-500 bg-white rounded-r-lg border border-gray-300 hover:bg-gray-100 hover:text-gray-700 dark:bg-gray-800 dark:border-gray-700 dark:text-gray-400 dark:hover:bg-gray-700 dark:hover:text-white">
                        <span class="sr-only">Next</span>
                        <svg class="w-5 h-5" aria-hidden="true" fill="currentColor" viewbox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd" />
                        </svg>
                    </a>
                </li>
            </ul>
        </nav>
    </div>

</div>


<div class="w-full mt-4 relative  shadow-md sm:rounded-lg overflow-auto ">

    <div class="w-full mt-4 relative  shadow-md sm:rounded-lg overflow-auto ">
        <div class="flex items-center justify-between flex-column flex-wrap md:flex-row space-y-4 md:space-y-0 pb-4 bg-white dark:bg-gray-900">

            <div class="mt-2 mx-4">
                <div class="Imprest">
                    Users
                </div>
                <div class="pettyCash">
                    You can search any user or personal
                </div>
            </div>
            <div class="mt-2 mx-4">
                <label for="table-search" class="sr-only">Search</label>
                <div class="relative">
                    <div class="absolute inset-y-0 rtl:inset-r-0 start-0 flex items-center ps-3 pointer-events-none">
                        <svg class="w-4 h-4 text-gray-500 dark:text-gray-400" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 20 20">
                            <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m19 19-4-4m0-7A7 7 0 1 1 1 8a7 7 0 0 1 14 0Z" />
                        </svg>
                    </div>
                    <input type="text" id="table-search-users" class="block p-2 ps-10 text-sm text-gray-900 border border-gray-300 rounded-lg bg-gray-50 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" placeholder="Search for users">
                </div>
            </div>
        </div>
        <table class="w-full text-sm text-left rtl:text-right text-gray-500 dark:text-gray-400">
            <thead class="text-xs text-gray-700 uppercase bg-gray-50 dark:bg-gray-700 dark:text-gray-400">
                <tr>

                    <th scope="col" class="px-6 py-3">
                        Name/ Created At
                    </th>
                    <th scope="col" class="px-6 py-3">
                        Phone/ Email
                    </th>
                    <th scope="col" class="px-6 py-3">
                        Status
                    </th>
                    <th scope="col" class="px-6 py-3">
                        Country/ State
                    </th>
                    <th scope="col" class="px-6 py-3">
                        Action
                    </th>
                </tr>
            </thead>

            <tbody>
                @foreach ($users as $user)
                <tr class="bg-white border-b dark:bg-gray-800 dark:border-gray-700 border-gray-200 hover:bg-gray-50 dark:hover:bg-gray-600">

                    <th scope="row" class="flex items-center px-6 py-4 text-gray-900 whitespace-nowrap dark:text-white">
                        <a href="/profile" class="">
                            <img class="w-10 h-10 rounded-full" src="{{asset($user->img)}}" alt="{{$user->id}}">
                        </a>

                        <a href="/profile" class="">
                            <div class="ps-3">
                                <div class="text-base font-semibold">{{$user->firstName}} {{$user->lastName}}</div>
                                <div class="font-normal text-gray-500">{{$user->created_at}}</div>
                            </div>
                        </a>
                    </th>
                    <td class="px-6 py-4">
                        <a href="/profile" class="">
                            <div class="text-base font-semibold">{{$user->phone}}</div>
                            <div class="font-normal text-gray-500">{{$user->email}}</div>
                        </a>

                    </td>
                    <td class="px-6 py-4">
                        <div class="flex items-center">
                            @if($user->phone_verified_at)
                            <div class="h-2.5 w-2.5 rounded-full bg-green-500 me-2"></div> verified
                            @else
                            <div class="h-2.5 w-2.5 rounded-full bg-red-500 me-2"></div> unverified
                            @endif
                        </div>
                        <div class="flex items-center">
                            @if($user->email_verified_at)
                            <div class="h-2.5 w-2.5 rounded-full bg-green-500 me-2"></div> verified
                            @else
                            <div class="h-2.5 w-2.5 rounded-full bg-red-500 me-2"></div> unverified
                            @endif
                        </div>
                    </td>
                    <td class="px-6 py-4">
                        <div class="text-base font-semibold">{{$user->country}}</div>
                        <div class="font-normal text-gray-500">{{$user->state}}</div>
                    </td>
                    <td class="flex px-6 py-4">

                        @if($user->status==="pending")
                        <form action="/admin/users-approve" method="post">
                            @csrf
                            <input type="hidden" name="userId" value="{{$user->id}}">
                            <button type="submit" title="Approve user" class="mx-1 h-10 w-10 bg-green-100 rounded-lg hover:bg-green-200 flex justify-center items-center">
                                <img class="h-5 w-5 rounded-lg" src="/icons/check-green.png" alt="" srcset="">
                            </button>
                        </form>
                        @endif
                        <button type="button" onclick='showUserModal("{{$user->id}}")' class="mx-1 h-10 w-10 bg-gray-100 rounded-lg hover:bg-blue-200">
                            <img class="h-10 w-10 rounded-lg" src="/icons/ButtonSettings.png" alt="" srcset="">
                        </button>
                        <div id="userModal{{$user->id}}" tabindex="-1" class="hidden bg-gray-800 bg-opacity-70 flex overflow-y-auto overflow-x-hidden fixed top-0  z-50 justify-center  w-full md:inset-0 h-[calc(100%-1rem)] max-h-full">
                            <div class="relative p-4 w-full max-w-md max-h-full">
                                <!-- Modal content -->
                                <div class="relative bg-white rounded-lg shadow-sm dark:bg-gray-700">
                                    <!-- Modal header -->
                                    <div class="flex items-center justify-between p-4 md:p-5 border-b rounded-t dark:border-gray-600 border-gray-200">
                                        <h3 class="text-xl font-semibold text-gray-900 dark:text-white">
                                            Assign Staff
                                        </h3>
                                        <button type="button" class="end-2.5 text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm w-8 h-8 ms-auto inline-flex justify-center items-center dark:hover:bg-gray-600 dark:hover:text-white" data-modal-hide="authentication-modal">
                                            <svg class="w-3 h-3" onclick='showUserModal("{{$user->id}}")' xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
                                                <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6" />
                                            </svg>
                                            <span class="sr-only">Close modal</span>
                                        </button>
                                    </div>
                                    <!-- Modal body -->
                                    <div class="p-4 md:p-5">
                                        <form class="space-y-4" action="/admin/deployments" method="post">
                                            @if(count($errors) > 0 )
                                            <ul class="" style="list-style: none;">
                                                @foreach($errors->all() as $error)
                                                <li>
                                                    <div class="p-4 mb-4 text-sm text-red-800 rounded-lg bg-red-50 dark:bg-gray-800 dark:text-red-400" role="alert">
                                                        <span class="font-medium">{{$error}}</span>
                                                    </div>
                                                </li>
                                                @endforeach
                                            </ul>
                                            @endif
                                            @csrf

                                            <input type="hidden" name="userID" value="{{$user->id}}">
                                            <div class="grid md:grid-cols-2 md:gap-6">
                                                <div class="relative z-0 w-full mb-5 group">
                                                    <select type="text" id="branchId" name="branchId" class="block py-2.5  px-2.5 px-0 w-full text-sm text-gray-900 bg-transparent border-0 border-b-2 border-gray-300 appearance-none dark:text-white dark:border-gray-600 dark:focus:border-blue-500 focus:outline-none focus:ring-0 focus:border-blue-600 peer" placeholder=" " required>
                                                        <option selected>Select Branch</option>
                                                        @if(count($theBranchs) > 0 )
                                                        @foreach($theBranchs->all() as $theBranch)
                                                        <option value="{{$theBranch->id}}">{{$theBranch->name}}</option>
                                                        @endforeach
                                                        @endif
                                                    </select>
                                                    <label for="branchId" class="peer-focus:font-medium absolute text-sm text-gray-500 dark:text-gray-400 duration-300 transform -translate-y-6 scale-75 top-3 -z-10 origin-[0] peer-focus:start-0 rtl:peer-focus:translate-x-1/4 peer-focus:text-blue-600 peer-focus:dark:text-blue-500 peer-placeholder-shown:scale-100 peer-placeholder-shown:translate-y-0 peer-focus:scale-75 peer-focus:-translate-y-6">Branch Office</label>
                                                </div>
                                                <div class="relative z-0 w-full mb-5 group">
                                                    <select type="text" id="unitId" name="unitId" class="block py-2.5 px-2.5 px-0 w-full text-sm text-gray-900 bg-transparent border-0 border-b-2 border-gray-300 appearance-none dark:text-white dark:border-gray-600 dark:focus:border-blue-500 focus:outline-none focus:ring-0 focus:border-blue-600 peer" placeholder=" " required>
                                                        <option selected>Select Unit</option>
                                                        @if(count($theUnits) > 0 )
                                                        @foreach($theUnits->all() as $theUnit)
                                                        <option value="{{$theUnit->id}}">{{$theUnit->name}}</option>
                                                        @endforeach
                                                        @endif
                                                    </select>
                                                    <label for="unitId" class="peer-focus:font-medium absolute text-sm text-gray-500 dark:text-gray-400 duration-300 transform -translate-y-6 scale-75 top-3 -z-10 origin-[0] peer-focus:start-0 rtl:peer-focus:translate-x-1/4 peer-focus:text-blue-600 peer-focus:dark:text-blue-500 peer-placeholder-shown:scale-100 peer-placeholder-shown:translate-y-0 peer-focus:scale-75 peer-focus:-translate-y-6">Unit</label>
                                                </div>
                                            </div>
                                            <div class="grid md:grid-cols-2 md:gap-6">
                                                <div class="relative z-0 w-full mb-5 group">
                                                    <select type="text" id="positions" name="positions" class="block py-2.5  px-2.5 px-0 w-full text-sm text-gray-900 bg-transparent border-0 border-b-2 border-gray-300 appearance-none dark:text-white dark:border-gray-600 dark:focus:border-blue-500 focus:outline-none focus:ring-0 focus:border-blue-600 peer" placeholder=" " required>
                                                        <option selected>Select Positions</option>
                                                        <option value="guard">Guard</option>
                                                        <option value="super">Super</option>
                                                        <option value="admin">Admin</option>
                                                    </select>
                                                    <label for="positions" class="peer-focus:font-medium absolute text-sm text-gray-500 dark:text-gray-400 duration-300 transform -translate-y-6 scale-75 top-3 -z-10 origin-[0] peer-focus:start-0 rtl:peer-focus:translate-x-1/4 peer-focus:text-blue-600 peer-focus:dark:text-blue-500 peer-placeholder-shown:scale-100 peer-placeholder-shown:translate-y-0 peer-focus:scale-75 peer-focus:-translate-y-6">positions</label>
                                                </div>
                                                <!-- <div class="relative z-0 w-full mb-5 group">
                                                    <input type="tel" id="phone" name="phone" class="block py-2.5 px-2.5 px-0 w-full text-sm text-gray-900 bg-transparent border-0 border-b-2 border-gray-300 appearance-none dark:text-white dark:border-gray-600 dark:focus:border-blue-500 focus:outline-none focus:ring-0 focus:border-blue-600 peer" placeholder=" " required />

                                                    <label for="phone" class="peer-focus:font-medium absolute text-sm text-gray-500 dark:text-gray-400 duration-300 transform -translate-y-6 scale-75 top-3 -z-10 origin-[0] peer-focus:start-0 rtl:peer-focus:translate-x-1/4 peer-focus:text-blue-600 peer-focus:dark:text-blue-500 peer-placeholder-shown:scale-100 peer-placeholder-shown:translate-y-0 peer-focus:scale-75 peer-focus:-translate-y-6">Phone</label>
                                                </div> -->
                                            </div>
                                            <div class="text-sm font-medium text-yellow-500 dark:text-yellow-300">
                                                By assigning this personnel to this unit, you agree to send a notification message to this staff member, which will carry legal obligations.
                                            </div>
                                            <button type="submit" class="w-full text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">Assign now</button>

                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <button class="mx-1 h-10 w-10 bg-gray-100 rounded-lg hover:bg-yellow-200">
                            <img class="h-10 w-10 rounded-lg" src="/icons/ButtonEdit.png" alt="" srcset="">
                        </button>
                        <button class="mx-1 h-10 w-10 bg-gray-100 rounded-lg hover:bg-red-200">
                            <img class="h-10 w-10 rounded-lg" src="/icons/lock-open.png" alt="" srcset="">
                        </button>
                        <button class="mx-1 h-10 w-10 bg-gray-100 rounded-lg hover:bg-gray-200">
                            <img class="h-10 w-10 rounded-lg" src="/icons/ButtonTrash.png" alt="" srcset="">
                        </button>
                    </td>
                </tr>
                @endforeach

            </tbody>
        </table>

        <nav class="flex flex-col md:flex-row justify-between items-start md:items-center space-y-3 md:space-y-0 p-4" aria-label="Table navigation">
            <!-- <span class="text-sm font-normal text-gray-500 dark:text-gray-400">
                Showing
                <span class="font-semibold text-gray-900 dark:text-white">{{$users['perPage']}}</span>
                of
                <span class="font-semibold text-gray-900 dark:text-white">{{$users['total']}}</span>
            </span> -->
            {{ $users->links() }}
        </nav>
    </div>
</div>
<script>
    const showUserModal = async (input) => {

        const modalDetails = document.getElementById(`userModal${input}`);

        if (modalDetails.classList.contains("hidden")) {
            modalDetails.classList.remove("hidden");
        } else {
            modalDetails.classList.add("hidden");
        }

    }
    async function fetchAsync(url, method, data) {

        const rawResponse = await fetch(url, {
            method,
            headers: {
                'Accept': 'application/json',
                'Content-Type': 'application/json',
            },
            body: JSON.stringify(data),
        });
        const content = await rawResponse.json();

        return content;
    }
    const showPayModal = async (input) => {
        const inputDetails = input.split("|");

        const modalDetails = document.getElementById(`modal${inputDetails[0]}`);

        if (modalDetails.classList.contains("hidden")) {
            modalDetails.classList.remove("hidden");
            const csrf = "zXJHMrMrfJiMY4FfLSIYfy3lXpiy42w7MB4M6bRr";

            const stateData = await fetchAsync("/verify-account", "POST", {
                bankCode: inputDetails[2],
                accountNumber: inputDetails[1],
                _token: csrf
            });

            if (stateData.status === "success") {
                const accountDetails = stateData.data;
                document.getElementById(`accountName${inputDetails[0]}`).innerHTML = `${accountDetails.account_name} <img class="h-10 w-10 rounded-lg" src="/icons/check-green.png" alt="" srcset="">`;
            }

        } else {
            modalDetails.classList.add("hidden");
        }

    }
</script>
@stop