@extends('layouts.adminDashboard',['title'=> "Settings"])
@section('statusmenue')


<nav class="bg-white border-gray-200 dark:bg-gray-900">
    <div class="flex justify-center w-full">
        <ul class="w-full flex mx-8 justify-center font-medium p-4 mt-4 border border-gray-100 rounded-lg bg-gray-50 space-x-8 ">
            <li>
                <a href="/admin/settings-unit" class="block py-2 px-3 text-gray-900 rounded-sm hover:bg-gray-100 md:hover:bg-transparent md:hover:text-blue-700 md:dark:hover:text-blue-500 dark:text-white dark:hover:bg-gray-700 dark:hover:text-white md:dark:hover:bg-transparent dark:border-gray-700">Branch Offices</a>

            </li>
            <li>
                <a href="/admin/settings" class="block py-2 px-3 text-white bg-blue-700 rounded-sm  text-blue-700 dark:text-blue-500" aria-current="page">Unit </a>
            </li>
            <li>
                <a href="#" class="block py-2 px-3 text-gray-900 rounded-sm hover:bg-gray-100 md:hover:bg-transparent md:hover:text-blue-700 md:dark:hover:text-blue-500 dark:text-white dark:hover:bg-gray-700 dark:hover:text-white md:dark:hover:bg-transparent dark:border-gray-700">Services</a>
            </li>
            <li>
                <a href="#" class="block py-2 px-3 text-gray-900 rounded-sm hover:bg-gray-100 md:hover:bg-transparent md:hover:text-blue-700 md:dark:hover:text-blue-500 dark:text-white dark:hover:bg-gray-700 dark:hover:text-white md:dark:hover:bg-transparent dark:border-gray-700">Contact</a>
            </li>
        </ul>
    </div>
</nav>
@stop


@section('content')
<div class="flex justify-end">
    <button onclick="showPayModal()" class="relative inline-flex items-center justify-center p-0.5 mb-2 me-2 overflow-hidden text-sm font-medium text-gray-900 rounded-lg group bg-gradient-to-br from-cyan-500 to-blue-500 group-hover:from-cyan-500 group-hover:to-blue-500 hover:text-white dark:text-white focus:ring-4 focus:outline-none focus:ring-cyan-200 dark:focus:ring-cyan-800">
        <span class="relative px-5 py-2.5 transition-all ease-in duration-75 bg-white dark:bg-gray-900 rounded-md group-hover:bg-transparent group-hover:dark:bg-transparent">
            New Unit
        </span>
    </button>
    <div id="modalNew" tabindex="-1" class="hidden bg-gray-800 bg-opacity-70 flex overflow-y-auto overflow-x-hidden fixed top-0  z-50 justify-center  w-full md:inset-0 h-[calc(100%-1rem)] max-h-full">
        <div class="relative p-4 w-full max-w-md max-h-full">
            <!-- Modal content -->
            <div class="relative bg-white rounded-lg shadow-sm dark:bg-gray-700">
                <!-- Modal header -->
                <div class="flex items-center justify-between p-4 md:p-5 border-b rounded-t dark:border-gray-600 border-gray-200">
                    <h3 class="text-xl font-semibold text-gray-900 dark:text-white">
                        Unit details
                    </h3>
                    <button type="button" class="end-2.5 text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm w-8 h-8 ms-auto inline-flex justify-center items-center dark:hover:bg-gray-600 dark:hover:text-white" data-modal-hide="authentication-modal">
                        <svg class="w-3 h-3" onclick='showPayModal()' xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 14 14">
                            <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6" />
                        </svg>
                        <span class="sr-only">Close modal</span>
                    </button>
                </div>
                <!-- Modal body -->
                <div class="p-4 md:p-5">
                    <form class="space-y-4 max-w-md mx-auto" action="/admin/unit-create" method="post">
                        @if(count($errors) > 0 )
                        <ul class="" style="list-style: none;">
                            @foreach($errors->all() as $error)
                            <li>
                                <div class="p-4 mb-4 text-sm text-red-800 rounded-lg bg-red-50 dark:bg-gray-800 dark:text-red-400" role="alert">
                                    <span class="font-medium">{{$error}}</span>
                                </div>
                            </li>
                            @endforeach
                        </ul>
                        @endif
                        @csrf

                        <div class="relative z-0 w-full mb-5 group">
                            <input type="text" name="name" id="name" value="{{old('name')}}" class="block py-2.5 px-0 w-full text-sm text-gray-900 bg-transparent border-0 border-b-2 border-gray-300 appearance-none dark:text-white dark:border-gray-600 dark:focus:border-blue-500 focus:outline-none focus:ring-0 focus:border-blue-600 peer" placeholder=" " required />
                            <label for="name" class="peer-focus:font-medium absolute text-sm text-gray-500 dark:text-gray-400 duration-300 transform -translate-y-6 scale-75 top-3 -z-10 origin-[0] peer-focus:start-0 rtl:peer-focus:translate-x-1/4 rtl:peer-focus:left-auto peer-focus:text-blue-600 peer-focus:dark:text-blue-500 peer-placeholder-shown:scale-100 peer-placeholder-shown:translate-y-0 peer-focus:scale-75 peer-focus:-translate-y-6">Name</label>
                        </div>
                        <div class="relative z-0 w-full mb-5 group">
                            <input type="text" name="address" id="address" value="{{old('address')}}" class="block py-2.5 px-0 w-full text-sm text-gray-900 bg-transparent border-0 border-b-2 border-gray-300 appearance-none dark:text-white dark:border-gray-600 dark:focus:border-blue-500 focus:outline-none focus:ring-0 focus:border-blue-600 peer" placeholder=" " required />
                            <label for="address" class="peer-focus:font-medium absolute text-sm text-gray-500 dark:text-gray-400 duration-300 transform -translate-y-6 scale-75 top-3 -z-10 origin-[0] peer-focus:start-0 rtl:peer-focus:translate-x-1/4 peer-focus:text-blue-600 peer-focus:dark:text-blue-500 peer-placeholder-shown:scale-100 peer-placeholder-shown:translate-y-0 peer-focus:scale-75 peer-focus:-translate-y-6">Address</label>
                        </div>

                        <div class="grid md:grid-cols-2 md:gap-6">
                            <div class="relative z-0 w-full mb-5 group">
                                <input type="email" id="email" name="email" class="block py-2.5  px-2.5 px-0 w-full text-sm text-gray-900 bg-transparent border-0 border-b-2 border-gray-300 appearance-none dark:text-white dark:border-gray-600 dark:focus:border-blue-500 focus:outline-none focus:ring-0 focus:border-blue-600 peer" placeholder=" " required />

                                <label for="email" class="peer-focus:font-medium absolute text-sm text-gray-500 dark:text-gray-400 duration-300 transform -translate-y-6 scale-75 top-3 -z-10 origin-[0] peer-focus:start-0 rtl:peer-focus:translate-x-1/4 peer-focus:text-blue-600 peer-focus:dark:text-blue-500 peer-placeholder-shown:scale-100 peer-placeholder-shown:translate-y-0 peer-focus:scale-75 peer-focus:-translate-y-6">Email</label>
                            </div>
                            <div class="relative z-0 w-full mb-5 group">
                                <input type="tel" id="phone" name="phone" class="block py-2.5 px-2.5 px-0 w-full text-sm text-gray-900 bg-transparent border-0 border-b-2 border-gray-300 appearance-none dark:text-white dark:border-gray-600 dark:focus:border-blue-500 focus:outline-none focus:ring-0 focus:border-blue-600 peer" placeholder=" " required />

                                <label for="phone" class="peer-focus:font-medium absolute text-sm text-gray-500 dark:text-gray-400 duration-300 transform -translate-y-6 scale-75 top-3 -z-10 origin-[0] peer-focus:start-0 rtl:peer-focus:translate-x-1/4 peer-focus:text-blue-600 peer-focus:dark:text-blue-500 peer-placeholder-shown:scale-100 peer-placeholder-shown:translate-y-0 peer-focus:scale-75 peer-focus:-translate-y-6">Phone</label>
                            </div>
                        </div>
                        <div class="grid md:grid-cols-2 md:gap-6">
                            <div class="relative z-0 w-full mb-5 group">
                                <select type="text" id="branchId" name="branchId" class="block py-2.5  px-2.5 px-0 w-full text-sm text-gray-900 bg-transparent border-0 border-b-2 border-gray-300 appearance-none dark:text-white dark:border-gray-600 dark:focus:border-blue-500 focus:outline-none focus:ring-0 focus:border-blue-600 peer" placeholder=" " required >
                                    <option selected>Select Branch</option>
                                    @if(count($branchs) > 0 )
                                    @foreach($branchs->all() as $branch)
                                    <option value="{{$branch->id}}">{{$branch->name}}</option>
                                    @endforeach
                                    @endif
                                </select>
                                <label for="branchId" class="peer-focus:font-medium absolute text-sm text-gray-500 dark:text-gray-400 duration-300 transform -translate-y-6 scale-75 top-3 -z-10 origin-[0] peer-focus:start-0 rtl:peer-focus:translate-x-1/4 peer-focus:text-blue-600 peer-focus:dark:text-blue-500 peer-placeholder-shown:scale-100 peer-placeholder-shown:translate-y-0 peer-focus:scale-75 peer-focus:-translate-y-6">Branch</label>
                            </div>
                            <div class="relative z-0 w-full mb-5 group">
                                <input type="text" id="client" name="client" class="block py-2.5 px-2.5 px-0 w-full text-sm text-gray-900 bg-transparent border-0 border-b-2 border-gray-300 appearance-none dark:text-white dark:border-gray-600 dark:focus:border-blue-500 focus:outline-none focus:ring-0 focus:border-blue-600 peer" placeholder=" " required />
                               
                                <label for="client" class="peer-focus:font-medium absolute text-sm text-gray-500 dark:text-gray-400 duration-300 transform -translate-y-6 scale-75 top-3 -z-10 origin-[0] peer-focus:start-0 rtl:peer-focus:translate-x-1/4 peer-focus:text-blue-600 peer-focus:dark:text-blue-500 peer-placeholder-shown:scale-100 peer-placeholder-shown:translate-y-0 peer-focus:scale-75 peer-focus:-translate-y-6">Client email/ phone</label>
                            </div>
                        </div>
                        <button type="submit" class="text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:outline-none focus:ring-blue-300 font-medium rounded-lg text-sm w-full sm:w-auto px-5 py-2.5 text-center dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">Create Unit</button>
                    </form>

                </div>
            </div>
        </div>
    </div>
</div>

<div class="relative overflow-x-auto shadow-md sm:rounded-lg">
    @if(\Session::has('message'))
    <ul class="" style="list-style: none;">
        <li>
            <div class="p-4 mb-4 text-sm text-green-800 rounded-lg bg-green-50 dark:bg-gray-800 dark:text-green-400" role="alert">
                <span class="font-medium">{{\Session::get('message')}}</span>
            </div>
        </li>
    </ul>
    @endif
    <table class="w-full text-sm text-left rtl:text-right text-gray-500 dark:text-gray-400">
        <thead class="text-xs text-gray-700 uppercase bg-gray-50 dark:bg-gray-700 dark:text-gray-400">
            <tr>
                <th scope="col" class="px-6 py-3">
                    Name
                </th>
                <th scope="col" class="px-6 py-3">
                    email
                </th>
                <th scope="col" class="px-6 py-3">
                    phone
                </th>
                <th scope="col" class="px-6 py-3">
                    address
                </th>
                <th scope="col" class="px-6 py-3">
                    Status
                </th>
                <th scope="col" class="px-6 py-3">

                </th>
            </tr>
        </thead>
        <tbody>
            @if(count($units) > 0 )
            @foreach($units->all() as $unit)
            <tr class="bg-white border-b dark:bg-gray-800 dark:border-gray-700 border-gray-200">
                <th scope="row" class="px-6 py-4 font-medium text-gray-900 whitespace-nowrap dark:text-white">
                    {{$unit->name}}
                </th>
                <td class="px-6 py-4">
                    {{$unit->email}}
                </td>
                <td class="px-6 py-4">
                    {{$unit->phone}}
                </td>
                <td class="px-6 py-4">
                    {{$unit->address}}
                </td>
                <td class="px-6 py-4 ">
                    @if($unit->status=="pending")
                    <span class="text-yellow-500">
                        @elseif($unit->status=="operational")
                        <span class="text-green-500">
                            @else
                            <span>
                                @endif
                                {{$unit->status}}</span>
                </td>
                <td class="flex px-6 py-4">
                    @if($unit->status=="pending")
                    <form action="/admin/unit-approve" method="post">
                        @csrf
                        <input type="hidden" name="unitId" id="unitId" value="{{$unit->id}}">
                        <button type="submit" title="Approve request" class="mx-1 h-10 w-10 bg-gray-100 rounded-lg hover:bg-green-200">
                            <img class="h-10 w-10 rounded-lg" src="/icons/check-green.png" alt="" srcset="">
                        </button>
                    </form>
                    @endif
                    <button class="mx-1 h-10 w-10 bg-gray-100 rounded-lg hover:bg-red-200">
                            <img class="h-10 w-10 rounded-lg" src="/icons/lock-open.png" alt="" srcset="">
                        </button>
                    <button class="mx-1 h-10 w-10 bg-gray-100 rounded-lg hover:bg-gray-200">
                        <img class="h-10 w-10 rounded-lg" src="/icons/ButtonTrash.png" alt="" srcset="">
                    </button>
                </td>
            </tr>
            @endforeach
            @endif
        </tbody>
    </table>
</div>

<script>
    function removeOptions(selectElement) {
        var i, L = selectElement.options.length - 1;
        for (i = L; i >= 0; i--) {
            selectElement.remove(i);
        }
    }
    async function fetchAsync(url) {
        let response = await fetch(url);
        let data = await response.json();
        return data;
    }
    const showPayModal = async () => {
        const modalDetails = document.getElementById(`modalNew`);

        if (modalDetails.classList.contains("hidden")) {
            modalDetails.classList.remove("hidden");
        } else {
            modalDetails.classList.add("hidden");
        }

    }
    const loadStateData = async () => {
        const stateData = await fetchAsync("/state-lag");
        localStorage.setItem("rawState", JSON.stringify(stateData));
        $(document).ready(function() {
            Object.keys(stateData).forEach(sta => {
                $("#state").append($('<option>', {
                    value: sta,
                    text: sta
                }));
            });

        });
        $(document).ready(function() {

            stateData["Abia"].forEach(lga => {
                $("#lga").append($('<option>', {
                    value: lga,
                    text: lga
                }));
            });

        });
    }

    loadStateData();

    const handleStateChange = () => {
        removeOptions(document.getElementById('lga'));
        const rawState = JSON.parse(localStorage.getItem("rawState"));
        const newState = document.getElementById("state").value;
        $(document).ready(function() {
            rawState[newState].forEach(lga => {
                $("#lga").append($('<option>', {
                    value: lga,
                    text: lga
                }));
            });

        });
    }
</script>
@stop