@extends('layouts.auth',["title"=>"login", "state"=>5, "showSteps"=> 1])
@section('content')
<div class="w-full mt-6 lg:mt-12">
    <div class="w-full px-8">
        <div class="title flex">
            <div class="create-account3">Guarantor Info</div>
            <div class="addButton">
                <div class="add-more">Generate Link</div>
            </div>
        </div>
        <form id="guarantorForm" method="post" action="/guarantor" class="frame-167">
            @if(count($errors) > 0 )

            <ul class="" style="list-style: none;">
                @foreach($errors->all() as $error)
                <li>
                    <div class="p-4 mb-4 text-sm text-red-800 rounded-lg bg-red-50 dark:bg-gray-800 dark:text-red-400" role="alert">
                        <span class="font-medium">{{$error}}</span>
                    </div>
                </li>
                @endforeach
            </ul>

            @endif
            @if(\Session::has('message'))
            <ul class="" style="list-style: none;">
                <li>
                    <div class="p-4 mb-4 text-sm text-green-800 rounded-lg bg-green-50 dark:bg-gray-800 dark:text-green-400" role="alert">
                        <span class="font-medium">{{\Session::get('message')}}</span>
                    </div>
                </li>
            </ul>
            @endif
            @csrf
            <div class="mb-2 w-full">
                <label for="fullName" class="block mb-2 lable dark:text-white">Full Name</label>
                <div class="flex ">
                    <select class="block w-1/6 p-4 text-gray-900 mx-1 border-l border-t border-b border-gray-300 rounded-t-lg rounded-b-lg rounded-l-lg bg-gray-50 text-base focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" id="title" name="title" type="text">
                        <option value="Mr">Mr</option>
                        <option value="Mrs">Mrs</option>
                        <option value="Miss">Miss</option>
                        <option value="Sir">Sir</option>
                    </select>
                    <input type="text" id="fullName" name="fullName" placeholder="Enter full name" class="block mx-1 w-full p-4 text-gray-900 border-r border-t border-b border-gray-300 rounded-t-lg rounded-b-lg rounded-r-lg bg-gray-50 text-base focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                </div>
            </div>
            <div class="mb-2 w-full">
                <label for="address" class="block mb-2 lable dark:text-white">Home Address</label>
                <input type="text" id="address" name="address" placeholder="Enter your house Address" class="block w-full p-4 text-gray-900 border border-gray-300 rounded-lg bg-gray-50 text-base focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
            </div>
            <div class="flex flex-wrap mb-2 w-full">
                <div class="w-full md:w-1/2 px-1 mb-2 md:mb-0">
                    <label class="block mb-2 lable dark:text-white" for="email">
                        Email
                    </label>
                    <input class="block w-full p-4 text-gray-900 border border-gray-300 rounded-lg bg-gray-50 text-base focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" id="email" name="email" type="email" placeholder="Enter your email address">
                </div>
                <div class="w-full md:w-1/2 px-1">
                    <label class="block mb-2 lable dark:text-white" for="phone">
                        Phone
                    </label>
                    <input class="block w-full p-4 text-gray-900 border border-gray-300 rounded-lg bg-gray-50 text-base focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" id="phone" name="phone" type="text" placeholder="Enter your phone number">
                </div>
            </div>
            <div class="flex flex-wrap mb-2 w-full">
                <div class="w-full md:w-1/2 px-1 mb-2 md:mb-0">
                    <label class="block mb-2 lable dark:text-white" for="nin">
                        Nin
                    </label>
                    <input class="block w-full p-4 text-gray-900 border border-gray-300 rounded-lg bg-gray-50 text-base focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" id="nin" name="nin" type="number" placeholder="Enter your nin">
                </div>
                <div class="w-full md:w-1/2 px-1">
                    <label class="block mb-2 lable dark:text-white" for="passport">
                        Passport
                    </label>
                    <input class="block w-full p-4 text-gray-900 border border-gray-300 rounded-lg bg-gray-50 text-base focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" id="passport" name="passport" type="file" placeholder="select passport">
                </div>
            </div>

            <div class="flex flex-wrap mb-2 w-full">
                <div class="w-full md:w-1/2 px-1 mb-2 md:mb-0">
                    <label class="block mb-2 lable dark:text-white" for="employer">
                        Current Employer
                    </label>
                    <input class="block w-full p-4 text-gray-900 border border-gray-300 rounded-lg bg-gray-50 text-base focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" id="employer" name="employer" type="text" placeholder="Enter your employer name">
                </div>
                <div class="w-full md:w-1/2 px-1">
                    <label class="block mb-2 lable dark:text-white" for="jobTitle">
                        Job Title
                    </label>
                    <input class="block w-full p-4 text-gray-900 border border-gray-300 rounded-lg bg-gray-50 text-base focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" id="jobTitle" name="jobTitle" type="text" placeholder="Enter your job title">
                </div>
            </div>

        </form>
    </div>
    <style>
        .addButton,
        .addButton * {
            box-sizing: border-box;
        }

        .addButton {
            background: #000000;
            border-radius: 8.64px;
            padding: 12px 16px 12px 16px;
            display: flex;
            flex-direction: row;
            gap: 0px;
            align-items: center;
            justify-content: center;
            flex-shrink: 0;
            height: 48px;
            position: relative;
        }

        .add-more {
            color: #ffffff;
            text-align: center;
            font-family: "Poppins-SemiBold", sans-serif;
            font-size: 14.399999618530273px;
            font-weight: 600;
            position: relative;
            height: 22.92px;
        }
    </style>
    <div class="mx-8"> I hereby agree and understand that as a guarantor, I take full responsibility for ensuring that <span class="text-blue-500"> {{Auth::user()->firstName}} {{Auth::user()->lastName}} </span> upholds all obligations, including but not limited to conduct, compliance with company policies, and any other commitments required by their employment. I confirm my readiness to support and vouch for their credibility and adherence to these responsibilities. <a href="#" class="text-yellow-500"> Terms & Conditions </a>
    </div>
    <div class="flex justify-center mt-2">
        <button onclick="submiteForm()" class="addButton">
            <div class="add-more">Add Guarantor</div>
        </button>
    </div>
    <div class="arrows2 mt-8 px-8">
        <a href="/next-of-kin" class="buttonPre">
            <img class="arrow-right" src="/icons/Arrow-left.png" />
            <div class="next">Previous</div>
        </a>
        <a href="/dashboard" class="button">
            <div class="next">Next</div>
            <img class="arrow-right" src="/icons/Arrow-right.png" />
        </a>
    </div>
</div>
<script>
    const submiteForm = () => {
        document.getElementById("guarantorForm").submit();
    }
</script>
@stop