@extends('layouts.auth',["title"=>"login", "state"=>4, "showSteps"=> 1])
@section('content')
<div class="w-full mt-6 lg:mt-12">
    <div class="w-full px-8">
        <div class="title">
            <div class="create-account3">Next Of Kin</div>
        </div>
        <form id="nextKinForm" class="frame-167" method="post" action="/next-of-kin">
            @if(count($errors) > 0 )

            <ul class="" style="list-style: none;">
                @foreach($errors->all() as $error)
                <li>
                    <div class="p-4 mb-4 text-sm text-red-800 rounded-lg bg-red-50 dark:bg-gray-800 dark:text-red-400" role="alert">
                        <span class="font-medium">{{$error}}</span>
                    </div>
                </li>
                @endforeach
            </ul>

            @endif
            @csrf
            <div class="mb-2 w-full">
                <label for="fullName" class="block mb-2 lable dark:text-white">Full Name</label>
                <input type="text" id="fullName" name="fullName" value="{{old('fullName')}}" placeholder="Enter full name" class="block w-full p-4 text-gray-900 border border-gray-300 rounded-lg bg-gray-50 text-base focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
            </div>
            <div class="mb-2 w-full">
                <label for="relationship" class="block mb-2 lable dark:text-white">Relationship</label>
                <select class="block w-full p-4 text-gray-900 border border-gray-300 rounded-lg bg-gray-50 text-base focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" value="{{old('relationship')}}" id="relationship" name="relationship" type="text" placeholder="Jane">
                    <option selected>Select relationship</option>
                    <option value="friend">Friend</option>
                    <option value="parent">Parents</option>
                    <option value="siblings">Siblings</option>
                    <option value="spouse">Spouse</option>
                </select>
            </div>
            <div class="mb-2 w-full">
                <label for="phone" class="block mb-2 lable dark:text-white">Phone Number</label>
                <input type="number" id="phone" name="phone" value="{{old('phone')}}" placeholder="+23480123456789" class="block w-full p-4 text-gray-900 border border-gray-300 rounded-lg bg-gray-50 text-base focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
            </div>
            <div class="mb-2 w-full">
                <label for="email" class="block mb-2 lable dark:text-white">Email</label>
                <input type="email" id="email" name="email" value="{{old('email')}}" placeholder="info@surepoint.com" class="block w-full p-4 text-gray-900 border border-gray-300 rounded-lg bg-gray-50 text-base focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
            </div>
            <div class="mb-2 w-full">
                <label for="homeAddress" class="block mb-2 lable dark:text-white">Home Address</label>
                <input type="text" id="homeAddress" name="homeAddress" value="{{old('homeAddress')}}" placeholder="Enter your house address" class="block w-full p-4 text-gray-900 border border-gray-300 rounded-lg bg-gray-50 text-base focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
            </div>
            <div class="mb-2 w-full">
                <label for="workAddress" class="block mb-2 lable dark:text-white">Addrsss Of Current Employment</label>
                <input type="text" id="workAddress" name="workAddress" value="{{old('workAddress')}}" placeholder="Enter your work address" class="block w-full p-4 text-gray-900 border border-gray-300 rounded-lg bg-gray-50 text-base focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
            </div>
        </form>
    </div>

    <div class="w-full arrows2 mt-8 px-8">
        <a href="/education" class="buttonPre">
            <img class="arrow-right" src="/icons/Arrow-left.png" />
            <div class="next">Previous</div>
        </a>
        <button onclick="submiteForm()" class="button">
            <div class="next">Next</div>
            <img class="arrow-right" src="/icons/Arrow-right.png" />
        </button>
    </div>
</div>
<script>
    const submiteForm = () => {
        document.getElementById("nextKinForm").submit();
    }
</script>
@stop