<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title>SecurePoint: Login</title>
    <link rel="icon" type="image/x-icon" href="/images/logo2.png">
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.1/jquery.min.js"></script>
    <!-- Styles / Scripts -->
    <?php if(file_exists(public_path('build/manifest.json')) || file_exists(public_path('hot'))): ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    <?php endif; ?>

    <style>
        .create-account,
        .create-account * {
            box-sizing: border-box;
        }

        .create-account {
            background: #ffffff;
            overflow: hidden;
            max-width: 1550px;
        }


        .right {
            background: #ffffff;
            display: flex;
            flex-direction: row;
            align-items: center;
            justify-content: center;
            overflow: hidden;
        }

        .container {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            flex-shrink: 0;
        }


        .icon {
            background: var(--colors-yellow, #ffcc00);
            border-radius: 11.52px;
            padding: 8px 18px 8px 18px;
            display: flex;
            flex-direction: column;
            gap: 10px;
            align-items: center;
            justify-content: center;
            flex-shrink: 0;
            width: 44px;
            height: 44px;
            position: relative;
        }

        ._1 {
            color: var(--m3-white, #ffffff);
            text-align: center;
            font-family: "Poppins-SemiBold", sans-serif;
            font-size: 18px;
            font-weight: 600;
            position: relative;
            width: 6.97px;
            height: 26.9px;
        }

        .create-account2 {
            color: #212121;
            text-align: left;
            font-family: "Poppins-SemiBold", sans-serif;
            font-size: 10px;
            line-height: 14px;
            letter-spacing: -0.01em;
            font-weight: 600;
            width: 65.88px;
        }

        .item-2 {
            display: flex;
            flex-direction: row;
            gap: 12px;
            align-items: center;
            justify-content: center;
            align-self: stretch;
        }

        .icon2 {
            background: #f9f6d7;
            border-radius: 11.52px;
            padding: 8px 16px 8px 16px;
            display: flex;
            flex-direction: column;
            gap: 10px;
            align-items: center;
            justify-content: center;
            flex-shrink: 0;
            width: 44px;
            height: 44px;
            position: relative;
        }

        ._2 {
            color: var(--colors-yellow, #ffcc00);
            text-align: center;
            font-family: "Poppins-SemiBold", sans-serif;
            font-size: 18px;
            font-weight: 600;
            position: relative;
        }

        .personal-info {
            color: #b5b5c3;
            text-align: left;
            font-family: "Poppins-SemiBold", sans-serif;
            font-size: 10px;
            line-height: 14px;
            font-weight: 600;
            position: relative;
            width: 53px;
        }

        .item-4 {
            display: flex;
            flex-direction: row;
            gap: 13px;
            align-items: center;
            justify-content: center;
        }

        .icon3 {
            background: #f9f6d7;
            border-radius: 11.52px;
            padding: 9px 16px 9px 16px;
            display: flex;
            flex-direction: column;
            gap: 10px;
            align-items: center;
            justify-content: center;
            position: relative;
        }

        ._3 {
            color: var(--colors-yellow, #ffcc00);
            text-align: center;
            font-family: "Poppins-SemiBold", sans-serif;
            font-size: 17.279998779296875px;
            font-weight: 600;
            position: relative;
        }

        .education {
            color: #b5b5c3;
            text-align: left;
            font-family: "Poppins-SemiBold", sans-serif;
            font-size: 10px;
            font-weight: 600;
            position: relative;
        }

        .item-3 {
            display: flex;
            flex-direction: row;
            gap: 12px;
            align-items: center;
            justify-content: center;
        }

        ._4 {
            color: var(--colors-yellow, #ffcc00);
            text-align: center;
            font-family: "Poppins-SemiBold", sans-serif;
            font-size: 18px;
            font-weight: 600;
            position: relative;
        }

        .next-of-kin {
            color: #b5b5c3;
            text-align: left;
            font-family: "Poppins-SemiBold", sans-serif;
            font-size: 10px;
            line-height: 14px;
            font-weight: 600;
            position: relative;
            width: 53px;
        }

        .item-5 {
            display: flex;
            flex-direction: row;
            gap: 12px;
            align-items: center;
            justify-content: center;
        }

        ._5 {
            color: var(--colors-yellow, #ffcc00);
            text-align: center;
            font-family: "Poppins-SemiBold", sans-serif;
            font-size: 18px;
            font-weight: 600;
            position: relative;
        }

        .guarantor-info {
            color: #b5b5c3;
            text-align: left;
            font-family: "Poppins-SemiBold", sans-serif;
            font-size: 10px;
            line-height: 14px;
            font-weight: 600;
            position: relative;
            width: 53px;
        }

        .title {
            flex-shrink: 0;
            width: "100%";
            justify-content: space-between;
        }

        .create-account3 {
            color: #2f3044;
            text-align: left;
            font-family: "Poppins-SemiBold", sans-serif;
            font-size: 28.799999237060547px;
            letter-spacing: -0.02em;
            font-weight: 600;
        }

        .frame-167 {
            display: flex;
            flex-direction: column;
            gap: 12px;
            align-items: flex-start;
            justify-content: flex-start;
            align-self: stretch;
            flex-shrink: 0;
            position: relative;
        }

        .lable {
            color: #2f3044;
            text-align: left;
            font-family: "Poppins-SemiBold", sans-serif;
            font-size: 14.399999618530273px;
            font-weight: 600;
        }

        .arrows {
            display: flex;
            flex-direction: row;
            align-items: center;
            justify-content: flex-end;
        }

        .arrows2 {
            display: flex;
            flex-direction: row;
            align-items: center;
            justify-content: space-between;
        }

        .button {
            background: var(--colors-yellow, #ffcc00);
            border-radius: 8.64px;
            padding: 12px 16px 12px 16px;
            display: flex;
            flex-direction: row;
            gap: 0px;
            align-items: center;
            justify-content: center;
            flex-shrink: 0;
            width: 118px;
            height: 48px;
            position: relative;
        }

        .buttonPre {
            background: var(--colors-yellow, #F9F6D7);
            border-radius: 8.64px;
            padding: 12px 16px 12px 16px;
            display: flex;
            flex-direction: row;
            gap: 0px;
            align-items: center;
            justify-content: center;
            flex-shrink: 0;
            width: 118px;
            height: 48px;
            position: relative;
        }

        .next {
            color: #ffffff;
            text-align: center;
            font-family: "Poppins-SemiBold", sans-serif;
            font-size: 14.399999618530273px;
            font-weight: 600;
            position: relative;
            width: 72px;
        }

        .arrow-right {
            flex-shrink: 0;
            width: 19.2px;
        }

        .header {
            flex-shrink: 0;
            width: 0px;
            height: 0px;
            position: static;
        }
    </style>
    <?php echo app('Illuminate\Foundation\Vite')('resources/css/app.css'); ?>
</head>

<body class="font-sans antialiased dark:bg-black dark:text-white/50">
    <div class="flex  create-account">
        <div class="hidden lg:block lg:w-1/2">
            <img
                class="h-full w-full object-cover"
                src="/images/auth_image.png" />
        </div>
        <div class="flex items-center justify-center w-full lg:w-1/2 bg-white">
            <div class="container lg:px-12 pb-8">
                <div class="lg:hidden w-full flex justify-center">
                    <img
                        class="object-cover h-full mt-4 mb-4"
                        src="/images/logo.png" />
                </div>
                <?php if($showSteps>0): ?>
                <ul class="flex flex-wrap w-full justify-center justify-self-center">
                    <?php if($state>1): ?>
                    <li class="justify-center items-center gap-[9px] flex">
                        <div class="w-11 h-11 p-2.5 bg-[#ffcc00] rounded-xl justify-start items-center gap-2.5 flex">
                            <img src="/icons/Check.png" />
                        </div>
                        <div class="w-[65.88px] text-[#212121] text-[10px] font-semibold font-['Poppins'] leading-[19.20px]">Create Account</div>
                    </li>
                    <?php else: ?>
                    <li class="flex justify-center ">
                        <div class="icon w-12 h-12 mx-2">
                            <div class="_1">1</div>
                        </div>
                        <div class="create-account2 my-3 hidden lg:block">Create Account</div>
                    </li>
                    <?php endif; ?>
                    <?php if($state>2): ?>
                    <li class="justify-center items-center gap-[9px] flex">
                        <div class="w-11 h-11 p-2.5 bg-[#ffcc00] rounded-xl justify-start items-center gap-2.5 flex">
                            <img src="/icons/Check.png" />
                        </div>
                        <div class="w-[65.88px] text-[#212121] text-[10px] font-semibold font-['Poppins'] leading-[19.20px]">Personal Info</div>
                    </li>
                    <?php elseif($state ==2): ?>
                    <li class="flex justify-center ">
                        <div class="icon w-12 h-12 mx-2">
                            <div class="_1">2</div>
                        </div>
                        <div class="create-account2 my-3 hidden lg:block">Personal Info</div>
                    </li>
                    <?php else: ?>
                    <li class="item-2 m-2">
                        <div class="icon2">
                            <div class="_2">2</div>
                        </div>
                        <div class="personal-info hidden lg:block">Personal Info</div>
                    </li>
                    <?php endif; ?>
                    <?php if($state>3): ?>
                    <li class="justify-center items-center gap-[9px] flex">
                        <div class="w-11 h-11 p-2.5 bg-[#ffcc00] rounded-xl justify-start items-center gap-2.5 flex">
                            <img src="/icons/Check.png" />
                        </div>
                        <div class="w-[65.88px] text-[#212121] text-[10px] font-semibold font-['Poppins'] leading-[19.20px]">Education</div>
                    </li>
                    <?php elseif($state ==3): ?>
                    <li class="flex justify-center ">
                        <div class="icon w-12 h-12 mx-2">
                            <div class="_1">3</div>
                        </div>
                        <div class="create-account2 my-3 hidden lg:block">Education</div>
                    </li>
                    <?php else: ?>
                    <li class="item-4 m-2">
                        <div class="icon3">
                            <div class="_3">3</div>
                        </div>
                        <div class="education hidden lg:block">Education</div>
                    </li>
                    <?php endif; ?>
                    <?php if($state>4): ?>
                    <li class="justify-center items-center gap-[9px] flex">
                        <div class="w-11 h-11 p-2.5 bg-[#ffcc00] rounded-xl justify-start items-center gap-2.5 flex">
                            <img src="/icons/Check.png" />
                        </div>
                        <div class="w-[65.88px] text-[#212121] text-[10px] font-semibold font-['Poppins'] leading-[19.20px]">Next Of Kin</div>
                    </li>
                    <?php elseif($state ==4): ?>
                    <li class="flex justify-center ">
                        <div class="icon w-12 h-12 mx-2">
                            <div class="_1">4</div>
                        </div>
                        <div class="create-account2 my-3 hidden lg:block">Next Of Kin</div>
                    </li>
                    <?php else: ?>
                    <li class="item-3 m-2">
                        <div class="icon2">
                            <div class="_4">4</div>
                        </div>
                        <div class="next-of-kin hidden lg:block">Next Of Kin</div>
                    </li>
                    <?php endif; ?>
                    <?php if($state>4): ?>
                    <li class="flex justify-center ">
                        <div class="icon w-12 h-12 mx-2">
                            <div class="_1">5</div>
                        </div>
                        <div class="create-account2 my-3 hidden lg:block">Guarantor Info</div>
                    </li>
                    <?php else: ?>
                    <li class="item-5 m-2">
                        <div class="icon2">
                            <div class="_5">5</div>
                        </div>
                        <div class="guarantor-info hidden lg:block">Guarantor Info</div>
                    </li>
                    <?php endif; ?>
                </ul>
                <?php endif; ?>
                <?php echo $__env->yieldContent('content'); ?>

            </div>
            <div class="header"></div>
        </div>
    </div>
</body>

</html><?php /**PATH C:\Users\USER\Documents\GitHub\SPS-ERP\resources\views\layouts\auth.blade.php ENDPATH**/ ?>